using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmViewReagentInventory
	/// </summary>
	public class FrmViewReagentInventory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.Button btnPrinnt;
		private DataTable _dtReagents;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picTubes;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvViewReagentInventory;
		private string _reportCriteria;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="status"></param>
		/// <param name="expirationDateAfter"></param>
		/// <param name="expirationDateBefore"></param>
		/// <param name="receivedDateAfter"></param>
		/// <param name="receivedDateBefore"></param>
		/// <param name="reagentTypeList"></param>
		public FrmViewReagentInventory(char status, DateTime expirationDateAfter, 
										DateTime expirationDateBefore, DateTime receivedDateAfter, 
										DateTime receivedDateBefore, ArrayList reagentTypeList)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			using(new WaitCursor())
			{
				if (status == char.MinValue)
				{
					_reportCriteria = "Expiration Date Range (";
					_reportCriteria += Common.VBECSDateTime.FormatDateString(expirationDateAfter);
					_reportCriteria += " - ";
					_reportCriteria += Common.VBECSDateTime.FormatDateString(expirationDateBefore);
					_reportCriteria += ")";
				}
				else if (status == 'O')
				{
					_reportCriteria = "Expired Reagents";
				}
				else if (status == 'I')
				{
					_reportCriteria = "In-Date Reagents";
				}
				else if (status == 'U')
				{
					_reportCriteria = "Unsatisfactory Reagents";
				}

				_reportCriteria += ", ";

				_reportCriteria += "Received Date Range (";
				_reportCriteria += Common.VBECSDateTime.FormatDateString(receivedDateAfter);
				_reportCriteria += " - ";
				_reportCriteria += Common.VBECSDateTime.FormatDateString(receivedDateBefore);
				_reportCriteria += ")";

				if (reagentTypeList.Count > 0)
				{
					_reportCriteria += ", ";
					_reportCriteria += "Reagent Types (";

					for (int i = 0 ; i < reagentTypeList.Count ; i++)
					{
						if (i == reagentTypeList.Count - 1)
						{
							_reportCriteria += reagentTypeList[i].ToString();
						}
						else
						{
							_reportCriteria += reagentTypeList[i].ToString() + ", ";
						}
					}
					_reportCriteria += ")";
				}

				LoadReagents(status, expirationDateAfter, expirationDateBefore, receivedDateAfter, receivedDateBefore, reagentTypeList);
				LoadReport();
				if (Common.Utility.IsDefaultPrinterConfigured == false)
				{
					this.btnPrinnt.Enabled = false;
				}
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmViewReagentInventory));
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrinnt = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.picTubes = new System.Windows.Forms.PictureBox();
            this.rvViewReagentInventory = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picTubes)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(728, 30);
            this.vbecsLogo1.TabIndex = 3;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 555);
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Abort;
            this.btnCancel.Location = new System.Drawing.Point(652, 544);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrinnt
            // 
            this.btnPrinnt.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrinnt.Image = ((System.Drawing.Image)(resources.GetObject("btnPrinnt.Image")));
            this.btnPrinnt.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrinnt.Location = new System.Drawing.Point(572, 544);
            this.btnPrinnt.Name = "btnPrinnt";
            this.btnPrinnt.Size = new System.Drawing.Size(75, 23);
            this.btnPrinnt.TabIndex = 1;
            this.btnPrinnt.Text = "&Print";
            this.btnPrinnt.Click += new System.EventHandler(this.btnPrinnt_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.picTubes);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 508);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // picTubes
            // 
            this.picTubes.Image = ((System.Drawing.Image)(resources.GetObject("picTubes.Image")));
            this.picTubes.Location = new System.Drawing.Point(4, 16);
            this.picTubes.Name = "picTubes";
            this.picTubes.Size = new System.Drawing.Size(45, 44);
            this.picTubes.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picTubes.TabIndex = 0;
            this.picTubes.TabStop = false;
            // 
            // rvViewReagentInventory
            // 
            this.rvViewReagentInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvViewReagentInventory.Location = new System.Drawing.Point(53, 37);
            this.rvViewReagentInventory.Name = "rvViewReagentInventory";
            this.rvViewReagentInventory.Size = new System.Drawing.Size(674, 501);
            this.rvViewReagentInventory.TabIndex = 6;
            // 
            // FrmViewReagentInventory
            // 
            this.AcceptButton = this.btnPrinnt;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(728, 569);
            this.Controls.Add(this.rvViewReagentInventory);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnPrinnt);
            this.Controls.Add(this.btnCancel);
            this.hlphelpChm.SetHelpKeyword(this, "View_Print_Inventory_.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 500);
            this.Name = "FrmViewReagentInventory";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - View Reagent Inventory";
            this.WindowState = System.Windows.Forms.FormWindowState.Maximized;
            this.Load += new System.EventHandler(this.FrmViewReagentInventory_Load);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.btnPrinnt, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvViewReagentInventory, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picTubes)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "View Reagent Inventory";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC020.FrmViewReagentInventory());
            BOL.VbecsReport.SetUpReportButtons(this.rvViewReagentInventory);
        }

		/// <summary>
		/// Load the reagent list from database
		/// </summary>
		private void LoadReagents(char Status, DateTime ExpirationDateAfter, DateTime ExpirationDateBefore, DateTime ReceivedDateAfter, DateTime ReceivedDateBefore, ArrayList ReagentTypeList)
		{
			string FilterExpression = "";
			DataTable dtAllReagents;
			DataRow[] drFilteredRows;
			int SortOrder = 0;
			int InspectionIndicator = 1;
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			if (Status == 'I')
			{
				ExpirationDateAfter = currentDate;
				InspectionIndicator = 1;
			}
			else if (Status == 'O')
			{
				ExpirationDateBefore = currentDate;
				InspectionIndicator = 1;
			}
			else if (Status == 'U')
			{
				InspectionIndicator = 0;
			}
			else
			{
				InspectionIndicator = -1;
			}

			dtAllReagents = BOL.Reagent.GetReagents(LogonUser.LogonUserDivisionCode, ExpirationDateBefore, ExpirationDateAfter, ReceivedDateBefore, ReceivedDateAfter);

			if (InspectionIndicator == -1)
			{
				FilterExpression = "(" + VbecsTables.Reagent.InspectionIndicator + " = 1 OR " + VbecsTables.Reagent.InspectionIndicator + " = 0)";
			}
			else
			{
				FilterExpression = VbecsTables.Reagent.InspectionIndicator + " = " + InspectionIndicator;
			}

			for (int i = 0 ; i < ReagentTypeList.Count ; i++)
			{
				if (i == 0)
				{
					FilterExpression +=  " AND (" + VbecsTables.ReagentType.ReagentTypeName + " = '" + ReagentTypeList[i].ToString() + "'";
				}
				else if (i == ReagentTypeList.Count - 1)
				{
					FilterExpression += " OR " + VbecsTables.ReagentType.ReagentTypeName + " = '" + ReagentTypeList[i].ToString() + "'";
				}
				else
				{
					FilterExpression += " OR " + VbecsTables.ReagentType.ReagentTypeName + " = '" + ReagentTypeList[i].ToString() + "'";
				}
			}
			if (ReagentTypeList.Count > 0)
			{
				FilterExpression += ")";
			}

			_dtReagents = dtAllReagents.Clone();
			_dtReagents.CaseSensitive = true;
			dtAllReagents.CaseSensitive = true;
			drFilteredRows = dtAllReagents.Select(FilterExpression, "SortColumn ASC, ReagentTypeName ASC, LotExpirationDate ASC, LotNumber ASC");
			foreach(DataRow drFilteredRow in drFilteredRows)
			{
				_dtReagents.Rows.Add(drFilteredRow.ItemArray);
			}

            //CR 3346
            _dtReagents.Columns.Add("Status");
            foreach (DataRow drReagentRow in _dtReagents.Rows)
            {
                if ((bool)drReagentRow[VbecsTables.Reagent.InspectionIndicator] == false)
                {
                    drReagentRow["Status"] = "U";
                }
                else if (((DateTime)drReagentRow[VbecsTables.Reagent.LotExpirationDate]) >= currentDate)
                {
                    drReagentRow["Status"] = "I";
                }
                else
                {
                    drReagentRow["Status"] = "O";
                }
            }

            _dtReagents.Columns.Add("SortReport", typeof(int));
            drFilteredRows = _dtReagents.Select("Status = 'I'", "SortColumn ASC, ReagentTypeName ASC, LotExpirationDate ASC, LotNumber ASC");
            foreach (DataRow drFilteredRow in drFilteredRows)
            {
                drFilteredRow["SortReport"] = SortOrder++;
            }

            drFilteredRows = _dtReagents.Select("Status = 'O'", "SortColumn ASC, ReagentTypeName ASC, LotExpirationDate DESC, LotNumber ASC");
            foreach (DataRow drFilteredRow in drFilteredRows)
            {
                drFilteredRow["SortReport"] = SortOrder++;
            }

            drFilteredRows = _dtReagents.Select("Status = 'U'", "SortColumn ASC, ReagentTypeName ASC, LotExpirationDate DESC, LotNumber ASC");
            foreach (DataRow drFilteredRow in drFilteredRows)
            {
                drFilteredRow["SortReport"] = SortOrder++;
            }

		}

		/// <summary>
		/// Set up the data source for the report and report viewer
		/// </summary>
		private void LoadReport()
		{
            
			//DataSet dsReagents = new DataSet();
			if (_dtReagents.Rows.Count == 0)
			{
				DataRow dr = _dtReagents.NewRow();
				dr[VbecsTables.Reagent.ReagentGuid] = Guid.Empty;
				dr[VbecsTables.Reagent.ReagentTypeId] = 0;
				dr[VbecsTables.ReagentType.ReagentTypeName] = "";
				dr[VbecsTables.Reagent.ReagentName] = "No Reagents Found";
				dr["SortColumn"] = 0;
				_dtReagents.Rows.Add(dr);
			}

			//dsReagents.Tables.Add(_dtReagents);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._reportCriteria);

            ReportDataSource reportSource = new ReportDataSource();
            reportSource.Name = "ViewReagentInventoryDataSet";
            reportSource.Value = this._dtReagents;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            reportSourceHeader.Name = "ReportHeaderDataSet";
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            reportSourceFooter.Name = "ReportFooterDataSet";
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.Reagents.ViewReagentInventory.rdlc");
            this.rvViewReagentInventory.LocalReport.DataSources.Add(reportSource);
            this.rvViewReagentInventory.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvViewReagentInventory.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvViewReagentInventory.LocalReport.LoadReportDefinition(stream);
            this.rvViewReagentInventory.RefreshReport();        
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrinnt_Click(object sender, System.EventArgs e)
		{
            //CR 3416 CR 3449
            try
            {
                this.rvViewReagentInventory.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmViewReagentInventory_Load(object sender, EventArgs e)
        {

            this.rvViewReagentInventory.RefreshReport();
        }
	}
}

